// TypeA.cpp : implementation file
//

#include "stdafx.h"
#include "rfidreader.h"
#include "TypeA.h"
#include "Share.h"
#include "RFID.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HANDLE			g_hCOM;
extern CString			StrTmp;
extern unsigned char	Buffer[512];
extern unsigned char	DeviceAddr;
BOOL					g_isAutoRd;
BOOL					g_isAutoWr;
UINT ThreadProcA(LPVOID ThreadParam);

/////////////////////////////////////////////////////////////////////////////
// CTypeA dialog


CTypeA::CTypeA(CWnd* pParent /*=NULL*/)
	: CDialog(CTypeA::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTypeA)
	m_intDecIdle = 0;
	m_intDecKey = 0;
	m_intEvallIdle = 0;
	m_intEvallKey = 0;
	m_intIncKey = 0;
	m_intIncIdle = 0;
	m_intInitIdle = 0;
	m_intInitKey = 0;
	m_intRdIdle = 0;
	m_intRdKey = 0;
	m_intWrIdle = 0;
	m_intWrKey = 0;
	m_intReqIdle = 0;
	m_strDecKey = _T("FF FF FF FF FF FF");
	m_strDecBlk = _T("01");
	m_strDecVal = _T("01 00 00 00");
	m_strEvallBlk = _T("01");
	m_strEvallKey = _T("FF FF FF FF FF FF");
	m_strIncBlk = _T("01");
	m_strIncKey = _T("FF FF FF FF FF FF");
	m_strIncVal = _T("01 00 00 00");
	m_strInitBlk = _T("01");
	m_strInitKey = _T("FF FF FF FF FF FF");
	m_strInitVal = _T("64 00 00 00");
	m_strRdKey = _T("FF FF FF FF FF FF");
	m_strRdnBlk = _T("01");
	m_strRdStartBlk = _T("10");
	m_strRetAMSG = _T("");
	m_strWrData = _T("FF FF FF FF FF FF FF FF FF FF FF FF FF FF AA BB");
	m_strWrKey = _T("FF FF FF FF FF FF");
	m_strWrnBlk = _T("01");
	m_strWrStartBlk = _T("10");
	//}}AFX_DATA_INIT
}


void CTypeA::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTypeA)
	DDX_Control(pDX, IDC_EDITRetAMSG, m_ctlRetAMSG);
	DDX_Control(pDX, IDC_BUTTONClear, m_btnClear);
	DDX_Control(pDX, IDC_BUTTONWrite, m_btnWrite);
	DDX_Control(pDX, IDC_BUTTONRequst, m_btnRequst);
	DDX_Control(pDX, IDC_BUTTONReadVal, m_btnReadVal);
	DDX_Control(pDX, IDC_BUTTONRead, m_btnRead);
	DDX_Control(pDX, IDC_BUTTONInit, m_btnInit);
	DDX_Control(pDX, IDC_BUTTONInc, m_btnInc);
	DDX_Control(pDX, IDC_BUTTONHalt, m_btnHalt);
	DDX_Control(pDX, IDC_BUTTONDec, m_btnDec);
	DDX_Radio(pDX, IDC_RADIODecIdle, m_intDecIdle);
	DDX_Radio(pDX, IDC_RADIODecKey, m_intDecKey);
	DDX_Radio(pDX, IDC_RADIOEvallIdle, m_intEvallIdle);
	DDX_Radio(pDX, IDC_RADIOEvallKey, m_intEvallKey);
	DDX_Radio(pDX, IDC_RADIOIncKey, m_intIncKey);
	DDX_Radio(pDX, IDC_RADIOIncIdle, m_intIncIdle);
	DDX_Radio(pDX, IDC_RADIOInitIdle, m_intInitIdle);
	DDX_Radio(pDX, IDC_RADIOInitKey, m_intInitKey);
	DDX_Radio(pDX, IDC_RADIORdIdle, m_intRdIdle);
	DDX_Radio(pDX, IDC_RADIORdKey, m_intRdKey);
	DDX_Radio(pDX, IDC_RADIOWrIdle, m_intWrIdle);
	DDX_Radio(pDX, IDC_RADIOWrKey, m_intWrKey);
	DDX_Radio(pDX, IDC_RADIOReqIdle, m_intReqIdle);
	DDX_Text(pDX, IDC_EDITDecKey, m_strDecKey);
	DDV_MaxChars(pDX, m_strDecKey, 17);
	DDX_Text(pDX, IDC_EDITDecBlk, m_strDecBlk);
	DDV_MaxChars(pDX, m_strDecBlk, 2);
	DDX_Text(pDX, IDC_EDITDecVal, m_strDecVal);
	DDV_MaxChars(pDX, m_strDecVal, 11);
	DDX_Text(pDX, IDC_EDITEvallBlk, m_strEvallBlk);
	DDV_MaxChars(pDX, m_strEvallBlk, 2);
	DDX_Text(pDX, IDC_EDITEvallKey, m_strEvallKey);
	DDV_MaxChars(pDX, m_strEvallKey, 17);
	DDX_Text(pDX, IDC_EDITIncBlk, m_strIncBlk);
	DDV_MaxChars(pDX, m_strIncBlk, 2);
	DDX_Text(pDX, IDC_EDITIncKey, m_strIncKey);
	DDV_MaxChars(pDX, m_strIncKey, 17);
	DDX_Text(pDX, IDC_EDITIncVal, m_strIncVal);
	DDV_MaxChars(pDX, m_strIncVal, 11);
	DDX_Text(pDX, IDC_EDITInitBlk, m_strInitBlk);
	DDV_MaxChars(pDX, m_strInitBlk, 2);
	DDX_Text(pDX, IDC_EDITInitKey, m_strInitKey);
	DDV_MaxChars(pDX, m_strInitKey, 17);
	DDX_Text(pDX, IDC_EDITInitVal, m_strInitVal);
	DDV_MaxChars(pDX, m_strInitVal, 11);
	DDX_Text(pDX, IDC_EDITRdKey, m_strRdKey);
	DDV_MaxChars(pDX, m_strRdKey, 17);
	DDX_Text(pDX, IDC_EDITRdnBlk, m_strRdnBlk);
	DDV_MaxChars(pDX, m_strRdnBlk, 2);
	DDX_Text(pDX, IDC_EDITRdStartBlk, m_strRdStartBlk);
	DDV_MaxChars(pDX, m_strRdStartBlk, 2);
	DDX_Text(pDX, IDC_EDITRetAMSG, m_strRetAMSG);
	DDX_Text(pDX, IDC_EDITWrData, m_strWrData);
	DDX_Text(pDX, IDC_EDITWrKey, m_strWrKey);
	DDV_MaxChars(pDX, m_strWrKey, 17);
	DDX_Text(pDX, IDC_EDITWrnBlk, m_strWrnBlk);
	DDV_MaxChars(pDX, m_strWrnBlk, 2);
	DDX_Text(pDX, IDC_EDITWrStartBlk, m_strWrStartBlk);
	DDV_MaxChars(pDX, m_strWrStartBlk, 2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTypeA, CDialog)
	//{{AFX_MSG_MAP(CTypeA)
	ON_BN_CLICKED(IDC_BUTTONRequst, OnBUTTONRequst)
	ON_BN_CLICKED(IDC_BUTTONHalt, OnBUTTONHalt)
	ON_BN_CLICKED(IDC_BUTTONRead, OnBUTTONRead)
	ON_BN_CLICKED(IDC_BUTTONWrite, OnBUTTONWrite)
	ON_BN_CLICKED(IDC_BUTTONInit, OnBUTTONInit)
	ON_BN_CLICKED(IDC_BUTTONInc, OnBUTTONInc)
	ON_BN_CLICKED(IDC_BUTTONDec, OnBUTTONDec)
	ON_BN_CLICKED(IDC_BUTTONReadVal, OnBUTTONReadVal)
	ON_EN_CHANGE(IDC_EDITRdnBlk, OnChangeEDITRdnBlk)
	ON_EN_CHANGE(IDC_EDITRdKey, OnChangeEDITRdKey)
	ON_EN_CHANGE(IDC_EDITRdStartBlk, OnChangeEDITRdStartBlk)
	ON_EN_CHANGE(IDC_EDITWrnBlk, OnChangeEDITWrnBlk)
	ON_EN_CHANGE(IDC_EDITWrKey, OnChangeEDITWrKey)
	ON_EN_CHANGE(IDC_EDITWrStartBlk, OnChangeEDITWrStartBlk)
	ON_EN_CHANGE(IDC_EDITWrData, OnChangeEDITWrData)
	ON_EN_CHANGE(IDC_EDITInitBlk, OnChangeEDITInitBlk)
	ON_EN_CHANGE(IDC_EDITInitKey, OnChangeEDITInitKey)
	ON_EN_CHANGE(IDC_EDITInitVal, OnChangeEDITInitVal)
	ON_EN_CHANGE(IDC_EDITIncBlk, OnChangeEDITIncBlk)
	ON_EN_CHANGE(IDC_EDITIncKey, OnChangeEDITIncKey)
	ON_EN_CHANGE(IDC_EDITIncVal, OnChangeEDITIncVal)
	ON_EN_CHANGE(IDC_EDITDecBlk, OnChangeEDITDecBlk)
	ON_EN_CHANGE(IDC_EDITDecKey, OnChangeEDITDecKey)
	ON_EN_CHANGE(IDC_EDITDecVal, OnChangeEDITDecVal)
	ON_EN_CHANGE(IDC_EDITEvallBlk, OnChangeEDITEvallBlk)
	ON_EN_CHANGE(IDC_EDITEvallKey, OnChangeEDITEvallKey)
	ON_BN_CLICKED(IDC_BUTTONClear, OnBUTTONClear)
	ON_BN_CLICKED(IDC_CHECKRdAuto, OnCHECKRdAuto)
	ON_BN_CLICKED(IDC_CHECKWrAuto, OnCHECKWrAuto)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTypeA message handlers

BOOL CTypeA::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_btnWrite.SetThemeHelper(&m_ThemeHelper);
	m_btnRequst.SetThemeHelper(&m_ThemeHelper);
	m_btnReadVal.SetThemeHelper(&m_ThemeHelper);
	m_btnRead.SetThemeHelper(&m_ThemeHelper);
	m_btnInit.SetThemeHelper(&m_ThemeHelper);
	m_btnInc.SetThemeHelper(&m_ThemeHelper);
	m_btnHalt.SetThemeHelper(&m_ThemeHelper);
	m_btnDec.SetThemeHelper(&m_ThemeHelper);
	m_btnClear.SetThemeHelper(&m_ThemeHelper);

	g_isAutoRd = FALSE;
	g_isAutoWr = FALSE;
	SetTimer(1, 300, NULL);
	//m_pThread = AfxBeginThread(ThreadProcA, this, THREAD_PRIORITY_NORMAL, 0, 0, NULL);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTypeA::OnBUTTONRequst()
{
	// TODO: Add your control notification handler code here
	unsigned char	Mode;
	CString			String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetAMSG);
		UpdateData(false);
		m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
		return;
	}

	Mode = m_intReqIdle ? 0x52 : 0x26;
	StrTmp.Format(">>GetUID Mode: %s\r\n", m_intReqIdle ?  "All" : "Idle");
	if ( (ret = API_MF_GET_SNR(g_hCOM, DeviceAddr, Mode, 0x00, Buffer)) != 0) {
	//if ( (ret = API_MF_Request(g_hCOM, DeviceAddr, Mode, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<%02X %02X %02X %02X\n", Buffer[2], Buffer[3], Buffer[4], Buffer[5]);
		StrTmp += String;
		String.Format("   %s card be detected", Buffer[1] ? "one more" : "one");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetAMSG);
	UpdateData(false);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONHalt() 
{
	// TODO: Add your control notification handler code here
	CString String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetAMSG);
		UpdateData(false);
		m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
		return;
	}

	StrTmp.Format(">>Halt\r\n");
	if ( (ret = API_MF_Halt(g_hCOM, DeviceAddr)) != 0) {
		String.Format("<<Halt fail: %s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<Halt Success!");
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetAMSG);
	UpdateData(false);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONRead()
{
	// TODO: Add your control notification handler code here
	unsigned char	Mode, nBlock, StartBlock;
	unsigned char	Key[32];
	CString			String;

	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetAMSG);
		UpdateData(false);
		m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
		return;
	}

	Mode = (unsigned char) (m_intRdKey << 1) | (m_intRdIdle);
	StartBlock = (unsigned char)strtol(m_strRdStartBlk, NULL, 16);
	nBlock = (unsigned char)strtol(m_strRdnBlk, NULL, 16);
	strcpy( (char *)Key, m_strRdKey);
	int SizeStr = CShare::OXStrtoD(Key);

	if (SizeStr != 6) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}
	
	StrTmp.Format(">>Reading    Start Address:%s  Blocks:%s\r\n", m_strRdStartBlk, m_strRdnBlk);
	if ( (ret = API_MF_Read(g_hCOM, DeviceAddr, Mode, StartBlock, nBlock, Key, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<UID: %02X %02X %02X %02X", Buffer[1], Buffer[2], Buffer[3], Buffer[4]);
		StrTmp += String;
		String.Format("\r\n<<Data: ");
		StrTmp += String;
		for (int i = 5; i <= Buffer[0]; i++) {
			String.Format("%02X ", Buffer[i]);
			StrTmp += String;
		}
	}

	CShare::WriteToResult(StrTmp, m_strRetAMSG);
	UpdateData(false);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONWrite() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Mode, nBlock, StartBlock;
	unsigned char	Key[64], SendData[1024];
	CString	String;
		
	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetAMSG);
		UpdateData(false);
		m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
		return;
	}

	Mode = (unsigned char) (m_intWrKey << 1) | (m_intWrIdle);
	nBlock = (unsigned char)strtol(m_strWrnBlk, NULL, 16);
	StartBlock = (unsigned char)strtol(m_strWrStartBlk, NULL, 16);
	strcpy( (char *)Key, m_strWrKey);
	int SizeStr = CShare::OXStrtoD(Key);
	strcpy( (char *)SendData, m_strWrData);
	int SizeStr1 = CShare::OXStrtoD(SendData);
	
	if (SizeStr != 6 || SizeStr1 != nBlock * 16) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}

	StrTmp.Format(">>Writing    Start Address:%s  Blocks:%s\r\n", m_strWrStartBlk, m_strWrnBlk);
	if ( (ret = API_MF_Write(g_hCOM, DeviceAddr, Mode, StartBlock, nBlock, Key, SendData, Buffer)) != 0) {
		String.Format("<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format("<<%02X %02X %02X %02X    Writing Success!", Buffer[1], Buffer[2], Buffer[3], Buffer[4]);
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetAMSG);
	UpdateData(false);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONInit() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Mode, BlockAddr;
	unsigned char	Key[32], Value[16];
	CString	String;
		
	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetAMSG);
		UpdateData(false);
		m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
		return;
	}

	Mode = (unsigned char) (m_intInitKey << 1) | (m_intInitIdle);
	BlockAddr = (unsigned char)strtol(m_strInitBlk, NULL, 16);
	strcpy( (char *)Key, m_strInitKey);
	int SizeStr1 = CShare::OXStrtoD(Key);
	strcpy( (char *)Value, m_strInitVal);
	int SizeStr2 = CShare::OXStrtoD(Value);

	if (SizeStr1 != 6 || SizeStr2 != 4) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}
	
	StrTmp.Format(">>Initialize    Sector:%s  Value:%s\r\n", m_strInitBlk, m_strInitVal);
	//StrTmp.Format(">>ʼ :%s\r\n", (char *)CShare::StrtoHEXStr(Key));
	//StrTmp.Format(">>ʼ :%02X %02X %02X %02X %02X %02X\r\n", Key[0], Key[1], Key[2], Key[3], Key[4], Key[5], Key[6]);
	if ( (ret = API_MF_InitVal(g_hCOM, DeviceAddr, Mode, BlockAddr, Key, Value, Buffer)) != 0) {
		String.Format(	"<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format(	"<<%02X %02X %02X %02X    Initialize Success!", Buffer[1], Buffer[2], Buffer[3], Buffer[4]);
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetAMSG);
	UpdateData(false);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONInc() 
{
	// TODO: Add your control notification handler code here
	unsigned char	Mode, BlockAddr;
	unsigned char	Key[32], Value[16];
	CString String;
		
	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetAMSG);
		UpdateData(false);
		m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
		return;
	}

	Mode = (unsigned char) (m_intIncKey << 1) | (m_intIncIdle);
	BlockAddr = (unsigned char)strtol(m_strIncBlk, NULL, 16);
	strcpy( (char *)Key, m_strIncKey);
	int SizeStr1 = CShare::OXStrtoD(Key);
	strcpy( (char *)Value, m_strIncVal);
	int SizeStr2 = CShare::OXStrtoD(Value);

	if (SizeStr1 != 6 || SizeStr2 != 4) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}
	
	StrTmp.Format(">>Increase    Sector:%s  Value:%s\r\n", m_strIncBlk, m_strIncVal);
	if ( (ret = API_MF_Inc(g_hCOM, DeviceAddr, Mode, BlockAddr, Key, Value, Buffer)) != 0) {
		String.Format(	"<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format(	"<<%02X %02X %02X %02X    Current Value: %02X%02X%02X%02X",
						Buffer[1], Buffer[2], Buffer[3], Buffer[4], 
						(Buffer[5]) ,(Buffer[6]) ,(Buffer[7]) , Buffer[8]);
//						(unsigned int)(Buffer[8]<<24) + (unsigned int)(Buffer[7]<<16) + (unsigned int)(Buffer[6]<<8) + (unsigned int)Buffer[5]);
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetAMSG);
	UpdateData(false);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONDec()
{
	// TODO: Add your control notification handler code here
	unsigned char	Mode, BlockAddr;
	unsigned char	Key[32], Value[16];
	CString String;
		
	UpdateData(true);
	if (INVALID_HANDLE_VALUE == g_hCOM) {
		CShare::WriteToResult("Please Connect to Device!", m_strRetAMSG);
		UpdateData(false);
		m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
		return;
	}

	Mode = (unsigned char) (m_intDecKey << 1) | (m_intDecIdle);
	BlockAddr = (unsigned char)strtol(m_strDecBlk, NULL, 16);
	strcpy( (char *)Key, m_strDecKey);
	int SizeStr1 = CShare::OXStrtoD(Key);
	strcpy( (char *)Value, m_strDecVal);
	int SizeStr2 = CShare::OXStrtoD(Value);
	
	if (SizeStr1 != 6 || SizeStr2 != 4) {
		MessageBox("Invalid format of the input parameters!", "Warning", MB_OK | MB_ICONINFORMATION);
		return;
	}

	StrTmp.Format(">>Decrease    Sector:%s  Value:%s\r\n", m_strDecBlk, m_strDecVal);
	if ( (ret = API_MF_Dec(g_hCOM, DeviceAddr, Mode, BlockAddr, Key, Value, Buffer)) != 0) {
		String.Format(	"<<%s!", CShare::Return_CodeError(Buffer[0]));
		StrTmp += String;
	}
	else {
		String.Format(	"<<%02X %02X %02X %02X    Current Value: %02X%02X%02X%02X", 
						Buffer[1], Buffer[2], Buffer[3], Buffer[4], 
						(Buffer[5]) ,(Buffer[6]) ,(Buffer[7]) , Buffer[8]);
//						(int)(Buffer[8]<<24) + (int)(Buffer[7]<<16) + (int)(Buffer[6]<<8) + (int)Buffer[5]);
		StrTmp += String;
	}

	CShare::WriteToResult(StrTmp, m_strRetAMSG);
	UpdateData(false);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONReadVal()
{
	// TODO: Add your control notification handler code here
}

void CTypeA::OnChangeEDITRdnBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdnBlk);
	m_strRdnBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITRdKey() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdKey);
	m_strRdKey = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITRdStartBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITRdStartBlk);
	m_strRdStartBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITWrnBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrnBlk);
	m_strWrnBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITWrKey() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrKey);
	m_strWrKey = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITWrStartBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrStartBlk);
	m_strWrStartBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITWrData() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITWrData);
	m_strWrData = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITInitBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITInitBlk);
	m_strInitBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITInitKey() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITInitKey);
	m_strInitKey = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITInitVal() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITInitVal);
	m_strInitVal = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITIncBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITIncBlk);
	m_strIncBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITIncKey() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITIncKey);
	m_strIncKey = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITIncVal() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITIncVal);
	m_strIncVal = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITDecBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITDecBlk);
	m_strDecBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITDecKey() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITDecKey);
	m_strDecKey = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITDecVal() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITDecVal);
	m_strDecVal = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITEvallBlk() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITEvallBlk);
	m_strEvallBlk = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnChangeEDITEvallKey() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDITEvallKey);
	m_strEvallKey = CShare::TxtChange(pEdit, nStart, nEnd);
	UpdateData(false);
	pEdit->SetSel(nStart, nEnd);
	m_ctlRetAMSG.LineScroll(m_ctlRetAMSG.GetLineCount() -1, 0);
}

void CTypeA::OnBUTTONClear() 
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	m_strRetAMSG = "";
	UpdateData(false);
}

void CTypeA::OnCHECKRdAuto() 
{
	// TODO: Add your control notification handler code here
	g_isAutoRd = ( ((CButton *)GetDlgItem(IDC_CHECKRdAuto))->GetCheck() & 1) ? TRUE : FALSE;
}

void CTypeA::OnCHECKWrAuto() 
{
	// TODO: Add your control notification handler code here
	g_isAutoWr = ( ((CButton *)GetDlgItem(IDC_CHECKWrAuto))->GetCheck() & 1) ? TRUE : FALSE;
}

void CTypeA::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CXPStyleButtonST *AutoButton1 = (CXPStyleButtonST *) GetDlgItem(IDC_BUTTONRead);
	CXPStyleButtonST *AutoButton2 = (CXPStyleButtonST *) GetDlgItem(IDC_BUTTONWrite);
	if (g_isAutoRd == TRUE) {
		AutoButton1->EnableWindow(FALSE);
		OnBUTTONRead();
	}
	else {
		AutoButton1->EnableWindow(TRUE);
	}

	if (g_isAutoWr == TRUE) {
		AutoButton2->EnableWindow(FALSE);
		OnBUTTONWrite();
	}
	else {
		AutoButton2->EnableWindow(TRUE);
	}
	CDialog::OnTimer(nIDEvent);
}

UINT ThreadProcA(LPVOID ThreadParam)
{
	CTypeA *pDlg = (CTypeA *)ThreadParam;
	CXPStyleButtonST *AutoButton1 = (CXPStyleButtonST *) pDlg->GetDlgItem(IDC_BUTTONRead);
	CXPStyleButtonST *AutoButton2 = (CXPStyleButtonST *) pDlg->GetDlgItem(IDC_BUTTONWrite);
	
	do {
		if (g_isAutoRd == TRUE) {
			AutoButton1->EnableWindow(FALSE);
			AutoButton1->SendMessage(WM_LBUTTONDOWN);
			AutoButton1->SendMessage(WM_LBUTTONUP);
		}
		else {
			AutoButton1->EnableWindow(TRUE);
		} 

		if (g_isAutoWr == TRUE) {
			AutoButton2->EnableWindow(FALSE);
			AutoButton2->SendMessage(WM_LBUTTONDOWN);
			AutoButton2->SendMessage(WM_LBUTTONUP);
		}
		else {
			AutoButton2->EnableWindow(TRUE);
		}

		Sleep(400);
	} while (1);
	
	return 0;
}
